//texture tex0 < string name = "Base.tga"; >;	// Base texture
//texture tex1 < string name = "Base.tga"; >;	// Base texture
//texture tex2 < string name = "Base.tga"; >;	// Base texture
//texture tex3 < string name = "Base.tga"; >;	// Base texture
//texture tex4 < string name = "Base.tga"; >;	// Base texture

float4x4 WorldViewProjectionMatrix; 

float3	LightPosition;
float3	CameraPosition;
float	Time;
float	vAlpha;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear; //Point;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler TheBackgroundTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear; //Point;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};


sampler TerraIncognitaFiltered  =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler WorldColor  =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler NormalMap  =
sampler_state
{
##	Texture = <tex4>;
	MinFilter = Linear; //Point;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};


struct VS_INPUT_WATER
{
    float3 position				: POSITION;
    float4 texCoord0			: TEXCOORD0;
    float4 texCoord1			: TEXCOORD1;
};

struct VS_OUTPUT_WATER
{
    float4 position		: POSITION;
    float4 texCoord0		: TEXCOORD0;

    float3 eyeDirection		: TEXCOORD1;
    float3 lightDirection	: TEXCOORD2;
    float3 halfAngleDirection	: TEXCOORD3;
    float4 WorldTexture		: TEXCOORD4;
};

const float3 offY = float3(0.11, 0.74, 0.43);
const float3 offZ = float3(0.47, 0.19, 0.78);

////////////////////////////////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT_WATER VertexShader_Water_2_0(const VS_INPUT_WATER IN )
{
   // Translate
   VS_OUTPUT_WATER OUT = (VS_OUTPUT_WATER)0;
   float4 position = mul( float4(IN.position.xyz , 1.0) , WorldViewProjectionMatrix );
   OUT.position = position;


   OUT.WorldTexture = IN.texCoord1;
	float4 tangent = float4(1.0, 0.0, 0.0, 0.0);
	float4 normal = float4(0.0, 1.0, 0.0, 0.0);
	float4 biTangent = float4(0.0, 0.0, 1.0, 0.0);
    
    OUT.texCoord0 = IN.texCoord0 + Time*0.1;

	float4 viewDir = float4( CameraPosition, 1 ) +(-position);
	OUT.eyeDirection.x = dot( viewDir, tangent );
	OUT.eyeDirection.y = dot( viewDir, normal );
	OUT.eyeDirection.z = dot( viewDir, biTangent );
//	OUT.eyeDirection.w = 1;

	float4 lightDir;
	lightDir.xyz = CameraPosition +(-LightPosition);
//	lightDir.w = 1;
	OUT.lightDirection.x = dot( viewDir, tangent );
	OUT.lightDirection.y = dot( viewDir, normal );
	OUT.lightDirection.z = dot( viewDir, biTangent );
//	OUT.lightDirection.w = 1;




   // Eye-linear texgen
   OUT.halfAngleDirection.x = 0.5 * (position.z + position.x);
   OUT.halfAngleDirection.y = 0.5 * (position.z +(-position.y) );
   OUT.halfAngleDirection.z = position.z;
   // Object-linear texgen
//   OUT.texCoord0 = 0.5 + 0.01 * position.xyzw;
   return OUT;
}


float4 PixelShader_Water_2_0( VS_OUTPUT_WATER IN ) : COLOR
{
	float3 noiseCoord = IN.texCoord0.xyz;
	// Slight flow downwards

	noiseCoord.x += 0.02 * Time;
	noiseCoord.y += 0.05 * Time;
	float4 noisy = tex2D(BaseTexture, noiseCoord.xy );

	// Some noise for watery effect
	noiseCoord.x = IN.texCoord0.y * 2;
	noiseCoord.y = IN.texCoord0.z + 0.1 * Time + noisy.x;

	// Create a normal from three noise components
	float3 normal;
	normal.x = tex2D(BaseTexture, noiseCoord.xy ).x;
	normal.y = tex2D(BaseTexture, noiseCoord.xy  + offY.xy).y;
	normal.z = tex2D(BaseTexture, noiseCoord.xy  + offZ.xy).x;
	normal = normalize(normal * 2 +(-1) );

	// Simply offset the texture coord for cheap refraction effect
	float2 coord = IN.halfAngleDirection.xy / IN.halfAngleDirection.z;

	float4 refr = tex2D(TheBackgroundTexture, coord + 0.02 * normal.xy);
	float4 normalTexture = tex2D( NormalMap, IN.texCoord0.xy );
	normalTexture = normalTexture * 2 +(-1);
	float3 lightReflection = (float3)reflect(-IN.lightDirection.xyz, (float3)normalTexture );
	lightReflection = normalize( lightReflection );
	float diff = dot( normalTexture.xyz, -lightReflection.xyz );
	float3 localView = normalize( IN.eyeDirection.xyz );		
	float spec = max(0.0, dot(lightReflection, localView) );
	spec = pow(spec, 2 );
	float4 color = float4( 0.2, 0.2, 0.2, 1 )* diff + spec *1.05f;
	float4 WorldClr = tex2D( WorldColor, IN.WorldTexture.xy );
	float4 OutColor = ( ( (color +(-noisy.y) ) * (1 +(-refr) ) )  + refr ) * WorldClr;
	OutColor.a = vAlpha;
	float4 TerraIncognita = tex2D( TerraIncognitaFiltered, IN.WorldTexture.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;
	OutColor.rgba += WorldClr.aaaa;
	return OutColor;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT_WATER VertexShader_Water_2_0_Simple(const VS_INPUT_WATER IN )
{
	VS_OUTPUT_WATER OUT = (VS_OUTPUT_WATER)0;
	OUT.position = mul( float4(IN.position.xyz, 1.0) , WorldViewProjectionMatrix );
	OUT.WorldTexture = IN.texCoord1;
	return OUT;
}

float4 PixelShader_Water_2_0_Simple( VS_OUTPUT_WATER IN ) : COLOR
{
	float4 OutColor = tex2D( WorldColor, IN.WorldTexture.xy );
	float4 TerraIncognita = tex2D( TerraIncognitaFiltered, IN.WorldTexture.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33 + OutColor.a;
	OutColor.a += vAlpha;
	return OutColor;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

technique WaterShader_2_0
{
	pass p0
	{
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Water_2_0();
		FragmentProgram = compile arbfp1 PixelShader_Water_2_0();
	}
}

technique WaterShader_1_1
{
	pass p0
	{
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Water_2_0_Simple();
		FragmentProgram = compile arbfp1 PixelShader_Water_2_0_Simple();
	}
}
